<Query Kind="Program">
  <Reference>&lt;RuntimeDirectory&gt;\System.IO.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Linq.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.XML.dll</Reference>
  <Reference>&lt;RuntimeDirectory&gt;\System.Xml.Serialization.dll</Reference>
  <Namespace>System.Net</Namespace>
  <Namespace>System.Xml.Schema</Namespace>
</Query>

void Main()
{
	var basePath = Util.CurrentQuery.Location;
	var maimlFiles = Directory.GetFiles(basePath + @"\Samples\", "*.maiml");
	var ns = NamespaceHelper.MaimlNamespaceUri;
	var dsigNs = NamespaceHelper.XmlDsigNamespaceUri;
	var xencNs = NamespaceHelper.XencNamespaceUri;
	var xsdPath = Path.Combine(basePath, "Schemas", "maiml.xsd");
	var dsigXsdPath = Path.Combine(basePath, "Schemas", "xmldsig-core-schema.xsd");
	var xencPath = Path.Combine(basePath, "Schemas", "xenc-schema.xsd");

	foreach (var maimlFile in maimlFiles)
	{
		var xmlDocCustomTemplate =  XmlHelper.LoadXmlDocument(ns,  xsdPath, dsigNs, dsigXsdPath, xencNs, xencPath, maimlFile);
	    try{
            //ValidationEventHandler eventHandler = new ValidationEventHandler(XmlHelper.ValidationCallBack);
            //xmlDocCustomTemplate.Validate(eventHandler);
            xmlDocCustomTemplate.Validate(XmlHelper.ValidationCallBack);
			if (XmlEvent.XmlError==0)
				Console.WriteLine($"OK ( {maimlFile} )");
			else {
				Console.WriteLine($"ERROR ( {maimlFile} )");
				XmlEvent.XmlError = 0;
			}
        }
		catch(XmlSchemaValidationException ex)
		//catch(Exception ex)
        {
			//Console.WriteLine("Err catch");
            Console.WriteLine(ex.Message);
        }
	}
}

// Define other methods and classes here
/// <summary>A namespace helper.</summary>
public static class NamespaceHelper
{
	/// <summary>A XML namespace URI</summary>
	public const string XmlNamespaceUri = "http://www.w3.org/2000/xmlns/";

	/// <summary>A XML Schema definition namespace URI</summary>
	public const string XsdNamespaceUri = "http://www.w3.org/2001/XMLSchema";

	/// <summary>A XML Schema instance namespace URI</summary>
	public const string XsiNamespaceUri = "http://www.w3.org/2001/XMLSchema-instance";

	/// <summary>A MaiML namespace URI</summary>
	public const string MaimlNamespaceUri = "http://www.maiml.org/schemas";
	
	/// <summary>A XML digital signature namespace URI</summary>
	public const string XmlDsigNamespaceUri = "http://www.w3.org/2000/09/xmldsig#";

	/// <summary>A XML encryption namespace URI</summary>
	public const string XencNamespaceUri = "http://www.w3.org/2001/04/xmlenc#";
	
}

public static class XmlEvent
{	
	public static int XmlError = 0;
}

/// <summary>An XML helper.</summary>
public static class XmlHelper
{
	/// <summary>Loads XML document.</summary>
	/// <param name="ns">     The ns.</param>
	/// <param name="xsdPath">Full pathname of the XSD file.</param>
	/// <param name="xmlPath">Full pathname of the XML file.</param>
	/// <returns>The XML document.</returns>
	public static XmlDocument LoadXmlDocument(string ns, string xsdPath, string dsigNs, string dsigXsdPath, string xencNs, string xencXsdPath, string xmlPath)
	{
		var xmlDocument = new XmlDocument();
		xmlDocument.PreserveWhitespace = true;

		XmlSchemaSet schemaSet = new XmlSchemaSet();
		schemaSet.XmlResolver = new XmlUrlResolver();
		schemaSet.Add(ns, xsdPath);
		schemaSet.Add(dsigNs, dsigXsdPath);
		schemaSet.Add(xencNs, xencXsdPath);

		xmlDocument.Schemas = schemaSet;
		var settings = new XmlReaderSettings()
		{
			DtdProcessing = DtdProcessing.Parse,
			XmlResolver = new XmlUrlResolver()
			{
				Credentials = CredentialCache.DefaultCredentials
			}
		};
		using (XmlReader reader = XmlReader.Create(xmlPath, settings))
		{
			xmlDocument.Load(reader);
		}
		return xmlDocument;
	}

	/// <summary>Calls back when the validation.</summary>
	/// <param name="sender">Source of the event.</param>
	/// <param name="args">  Validation event information.</param>
	public static void ValidationCallBack(object sender, ValidationEventArgs args)
	{
		XmlEvent.XmlError = -1;
		if (args.Severity == XmlSeverityType.Error)
		{
			//Debug.WriteLine("Error: " + args.Message);
			//args.Dump();
			var xmlSchemaValidationException = args.Exception as XmlSchemaValidationException;
			if (xmlSchemaValidationException != null)
			{
				//Console.WriteLine("Validate-CallBack-1");	
				xmlSchemaValidationException.DumpException();
			}
			else
			{
				//Console.WriteLine("Validate-CallBack-2");	
				args.Exception.DumpException();
			}
		}
	}
	
	public static void DumpException(this Exception exception)
	{
	 	//Console.WriteLine("DumpException-1");
		exception.Message.Dump();
		exception.GetType().FullName.Dump();
	}
	
	public static void DumpException(this XmlSchemaValidationException exception)
	{
		var data = new XmlSchemaValidationError()
		{
			Message = exception.Message,
		};

		var element = exception.SourceObject as XmlElement;
		if (element != null)
		{
	 		//Console.WriteLine("DumpException-2-1");
			data.SourceObject = element.GetDumpItem(true);
		}

		var attribute = exception.SourceObject as XmlAttribute;
		if (attribute != null)
		{
	 		//Console.WriteLine("DumpException-2-2");
			data.SourceObject = attribute.GetDumpItem();
		}

		data.Dump();
		//exception.Dump();
	}
	
	public static XmlDumpItem GetDumpItem(this XmlElement element, bool nested)
	{
	 	//Console.WriteLine("GetDumpItem-1");
		XmlDumpItem item = null;
		if (element != null)
		{
			item = new XmlDumpItem()
			{
				Current = element.OuterXml
			};

			if (nested)
			{
				var parentElement = element.ParentNode as XmlElement;
				item.Owner = parentElement.GetDumpItem(false);
			}
		}

		return item;
	}
	
	public static XmlDumpItem GetDumpItem(this XmlAttribute attribute)
	{
	 	//Console.WriteLine("GetDumpItem-2");
		XmlDumpItem item = null;
		if (attribute != null)
		{
			item = new XmlDumpItem()
			{
				Current = attribute.OuterXml
			};

			item.Owner = attribute.OwnerElement.GetDumpItem(true);
		}

		return item;
	}
	
}

public class XmlSchemaValidationError
{
	public string Message { get; set; }
	public XmlDumpItem SourceObject { get; set; }
}

public class XmlDumpItem
{
	public string Current { get; set; }
	public XmlDumpItem Owner { get; set; }
}
